/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.world.item.camera;

import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.world.camera.component.CompositionGuide;
import io.github.mortuusars.exposure.world.camera.component.CompositionGuides;
import io.github.mortuusars.exposure.world.camera.component.FlashMode;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import io.github.mortuusars.exposure.world.item.camera.CameraSetting;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class CameraSettings {
    private static final Map<class_2960, CameraSetting<?>> REGISTRY = new HashMap();
    public static final CameraSetting<Boolean> SELFIE_MODE = CameraSettings.register(Exposure.resource("selfie"), new CameraSetting<Boolean>(Exposure.DataComponents.SELFIE_MODE, Boolean.valueOf(false), new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)));
    public static final CameraSetting<Float> ZOOM = CameraSettings.register(Exposure.resource("zoom"), new CameraSetting<Float>(Exposure.DataComponents.ZOOM, Float.valueOf(0.0f), new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)));
    public static final CameraSetting<Double> SELFIE_ROTATION_X = CameraSettings.register(Exposure.resource("selfie_rotation_x"), new CameraSetting<Double>(Exposure.DataComponents.SELFIE_ROTATION_X, Double.valueOf(0.0), new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)));
    public static final CameraSetting<Double> SELFIE_ROTATION_Y = CameraSettings.register(Exposure.resource("selfie_rotation_y"), new CameraSetting<Double>(Exposure.DataComponents.SELFIE_ROTATION_Y, Double.valueOf(0.0), new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)));
    public static final CameraSetting<ShutterSpeed> SHUTTER_SPEED = CameraSettings.register(Exposure.resource("shutter_speed"), new CameraSetting<ShutterSpeed>(Exposure.DataComponents.SHUTTER_SPEED, ShutterSpeed.DEFAULT, new SoundEffect(Exposure.SoundEvents.CAMERA_DIAL_CLICK)));
    public static final CameraSetting<CompositionGuide> COMPOSITION_GUIDE = CameraSettings.register(Exposure.resource("composition_guide"), new CameraSetting<CompositionGuide>(Exposure.DataComponents.COMPOSITION_GUIDE, CompositionGuides.NONE, new SoundEffect(Exposure.SoundEvents.CAMERA_BUTTON_CLICK)));
    public static final CameraSetting<FlashMode> FLASH_MODE = CameraSettings.register(Exposure.resource("flash_mode"), new CameraSetting<FlashMode>(Exposure.DataComponents.FLASH_MODE, FlashMode.OFF, new SoundEffect(Exposure.SoundEvents.CAMERA_BUTTON_CLICK)));

    public static <T> CameraSetting<T> register(class_2960 id, CameraSetting<T> setting) {
        Preconditions.checkArgument((!REGISTRY.containsKey(id) ? 1 : 0) != 0, (String)"Setting with id '%s' is already registered.", (Object)id);
        REGISTRY.put(id, setting);
        return setting;
    }

    public static CameraSetting<?> byId(class_2960 id) {
        @Nullable CameraSetting<?> setting = REGISTRY.get(id);
        if (setting == null) {
            throw new IllegalStateException("Setting with id '" + String.valueOf(id) + "' is not registered.");
        }
        return setting;
    }

    public static class_2960 idOf(CameraSetting<?> setting) {
        for (Map.Entry<class_2960, CameraSetting<?>> entry : REGISTRY.entrySet()) {
            if (!entry.getValue().equals(setting)) continue;
            return entry.getKey();
        }
        throw new IllegalStateException("Setting is not registered.");
    }
}

